/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml.di;

import java.util.HashSet;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.jbpm.bpmn2.xml.di.BPMNEdgeHandler;
import org.jbpm.bpmn2.xml.di.BPMNPlaneHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPMNShapeHandler
extends BaseAbstractHandler
implements Handler {
    public BPMNShapeHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = true;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(BPMNPlaneHandler.ProcessInfo.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(NodeInfo.class);
        this.validPeers.add(BPMNEdgeHandler.ConnectionInfo.class);
    }

    @Override
    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String elementRef = attrs.getValue("bpmnElement");
        NodeInfo nodeInfo = new NodeInfo(elementRef);
        BPMNPlaneHandler.ProcessInfo processInfo = (BPMNPlaneHandler.ProcessInfo)parser.getParent();
        processInfo.addNodeInfo(nodeInfo);
        return nodeInfo;
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        NodeInfo nodeInfo = (NodeInfo)parser.getCurrent();
        Node xmlNode = element.getFirstChild();
        while (xmlNode instanceof Element) {
            String nodeName = xmlNode.getNodeName();
            if ("Bounds".equals(nodeName)) {
                String x = ((Element)xmlNode).getAttribute("x");
                String y = ((Element)xmlNode).getAttribute("y");
                String width = ((Element)xmlNode).getAttribute("width");
                String height = ((Element)xmlNode).getAttribute("height");
                try {
                    int xValue = new Float(x).intValue();
                    int yValue = new Float(y).intValue();
                    int widthValue = new Float(width).intValue();
                    int heightValue = new Float(height).intValue();
                    nodeInfo.setX(xValue);
                    nodeInfo.setY(yValue);
                    nodeInfo.setWidth(widthValue);
                    nodeInfo.setHeight(heightValue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid bounds for node " + nodeInfo.getNodeRef(), e);
                }
            }
            xmlNode = xmlNode.getNextSibling();
        }
        return parser.getCurrent();
    }

    @Override
    public Class<?> generateNodeFor() {
        return NodeInfo.class;
    }

    public static class NodeInfo {
        private String nodeRef;
        private Integer x;
        private Integer y;
        private Integer width;
        private Integer height;

        public NodeInfo(String nodeRef) {
            this.nodeRef = nodeRef;
        }

        public String getNodeRef() {
            return this.nodeRef;
        }

        public Integer getX() {
            return this.x;
        }

        public void setX(Integer x) {
            this.x = x;
        }

        public Integer getY() {
            return this.y;
        }

        public void setY(Integer y) {
            this.y = y;
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public Integer getHeight() {
            return this.height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }
    }
}

